--Order of Battle - Aircraft/Helicopter
--organized in units (squadrons/regiments) containing a number of aircraft
--Campaign Version-V20.00
--[[ Unit Entry Example ----------------------------------------------------------------------------

[1] = {
	inactive = true,								--true if unit is not active
	player = true,									--true for player unit
	name = "527 TFS",								--unit name
	type = "F-5E-3",								--aircraft type
	helicopter = true,								--true for helicopter units
	country = "USA",								--unit country
	livery = {"USAF Euro Camo"},					--unit livery
	base = "Groom Lake AFB",						--unit base
	skill = "Random",								--unit skill
	tasks = {										--list of eligible unit tasks. Note: task names do not necessary match DCS tasks)
		["AWACS"] = true,							
		["Anti-ship Strike"] = true,
		["CAP"] = true,
		["Fighter Sweep"] = true,	
		["Intercept"] = true,
		["Reconnaissance"] = true,
		["Refueling"] = true,
		["Strike"] = true,							--Generic air-ground task (replaces "Ground Attack", "CAS" and "Pinpoint Strike")
		["Transport"] = true,
		["Escort"] = true,							--Support task: Fighter escort for package
		["SEAD"] = true,							--Support task: SEAD escort for package
		["Escort Jammer"] = true,					--Support task: Single airraft in center of package for defensive jamming
		["Flare Illumination"] = true,				--Support task: Illuminate target with flares for package
		["Laser Illumination"] = true,				--Support task: Lase target for package
		["Stand-Off Jammer"] = true,				--Not implemeted yet: On-station jamming
		["Chaff Escort"] = true,					--Not implemented yet: Lay chaff corrdior ahead of package
		["A-FAC"] = true,							--Not implemented yet: Airborne forward air controller
	},
	number = 12,									--number of airframes
},

]]-----------------------------------------------------------------------------------------------------

oob_air = {
	["blue"] = {											--side 1
		{
			name = "1st Iranian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "Iran",								--unit country
			livery = {"IRIAA Generic"},					--unit livery
			base = "Havadarya",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "2nd Iranian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "Iran",								--unit country
			livery = {"IRIAA Generic"},					--unit livery
			base = "FARP London",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "3rd Iranian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "Iran",								--unit country
			livery = {"IRIAA Generic"},					--unit livery
			base = "Lar",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "4th Iranian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "Iran",								--unit country
			livery = {"IRIAA Generic"},					--unit livery
			base = "Shiraz Intl",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "41 TFS",								--unit name
			player = false,									--player unit
			inactive = false,
			type = "F-5E-3",								--aircraft type
			country = "Iran",						--unit country
			livery = "IR IRIAF Camo",			--unit livery
			parking_id = {
				["F"] = {13,15,17,19,21,23,25,26},
			},
			base = "Bandar Abbas Intl",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = false,
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Runway Attack"] = false,
			},
			number = 8,
			reserve = 36,
		},
		{
			name = "81 TFS",							--unit name
			type = "F-14A-135-GR",								--aircraft type
			player = true,									--player unit
			inactive = false,
			country = "Iran",								--unit country
			livery = {"IRIAF Asia Minor"},				--unit livery
			base = "Lar",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 2,
				["Escort"] = 2,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
			reserve = 24,
		},
		{
			name = "83 TFS",							--unit name
			type = "F-14A-135-GR",								--aircraft type
			player = false,									--player unit
			inactive = false,
			country = "Iran",								--unit country
			livery = {"IRIAF Asia Minor"},				--unit livery
			base = "Shiraz Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1.5,
				["CAP"] = 2,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 6,
			reserve = 24,
		},
		{
			name = "91 TFS",								--unit name
			type = "F-4E",								--aircraft type
			player = false,									--player unit
			inactive = false,
			country = "Iran",								--unit country
			livery = "IRIAF Asia Minor",						--unit livery
			parking_id = {
				["F"] = {1,12},
			},
			base = "Bandar Abbas Intl",						--unit base
			skill = "Random",
			tasks = {
				["Strike"] = true,
				["SEAD"] = true,
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Runway Attack"] = false,
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "23 TFS",								--unit name
			type = "F-4E",								--aircraft type
			player = false,									--player unit
			inactive = false,
			country = "Iran",								--unit country
			livery = "IRIAF Asia Minor",						--unit livery
			parking_id = {
				["D"] = {1,12},
			},
			base = "Shiraz Intl",						--unit base
			skill = "Random",
			tasks = {
				["Strike"] = true,
				["SEAD"] = true,
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Runway Attack"] = false,
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "Tanker sqd",								--unit name
			type = "KC135MPRS",								--aircraft type
			inactive = false,
			country = "Iran",								--unit country
			livery = {"IRIAF (2)"},									--unit livery
			parking_id = {
				["E"] = {1,4},
			},
			base = "Shiraz Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
			reserve = 4,
		},
		{
			name = "50 Squadron",								--unit name
			player = false,									--player unit
			type = "AH-1W",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "Iran",								--unit country
			livery = {"I.R.I.A.A"},									--unit livery
			base = "FARP London",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Escort"] = false,
				["Strike"] = true,
			},
			number = 6,
			reserve = 24,
		},
	},
	["red"] = {												--side 2
		{
			name = "Iraqi SAR Helicopter Squadron 1",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Iraq",								--unit country
			livery = {"Mi-17 Iraq"},					--unit livery      https://www.digitalcombatsimulator.com/fr/files/722478/
			base = "Khasab",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 1,
			reserve = 12,
		},
		{
			name = "Iraqi SAR Helicopter Squadron 2",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Iraq",								--unit country
			livery = {"Mi-17 Iraq"},					--unit livery      https://www.digitalcombatsimulator.com/fr/files/722478/
			base = "Qeshm Island",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 1,
			reserve = 12,
		},
		{
			name = "Iraqi SAR Helicopter Squadron 3",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Iraq",								--unit country
			livery = {"Mi-17 Iraq"},					--unit livery      https://www.digitalcombatsimulator.com/fr/files/722478/
			base = "Bandar Lengeh",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 1,
			reserve = 12,
		},
		{
			name = "Iraqi SAR Helicopter Squadron 4",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Iraq",								--unit country
			livery = {"Mi-17 Iraq"},					--unit livery      https://www.digitalcombatsimulator.com/fr/files/722478/
			base = "Sharjah Intl",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 1,
			reserve = 12,
		},
		{
			name = "Iraqi SAR Helicopter Squadron 5",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Iraq",								--unit country
			livery = {"Mi-17 Iraq"},					--unit livery      https://www.digitalcombatsimulator.com/fr/files/722478/
			base = "Abu Musa Island",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 1,
			reserve = 12,
		},
		{
			name = "21 Squadron",							--unit name
			type = "Su-17M4",							--aircraft type
			inactive = false,
			country = "Iraq",							--unit country
			livery = "Iraqi",					--unit livery
			parking_id = {
				[""] = {1,12},
			},
			base = "Al Maktoum Intl",						--unit base
			skill = "high",								--unit skill
			tasks = {
				["Strike"] = true,
				["Runway Attack"] = true,
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "73 Squadron",							--unit name
			type = "MiG-23MLD",								--aircraft type
			inactive = false,
			country = "Iraq",							--unit country
			livery = "af standard-2",						--unit livery
			parking_id = {
				[""] = {22,33},
			},
			base = "Sharjah Intl",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
				["Runway Attack"] = false,
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "109 Squadron",								--unit name
			type = "Su-17M4",								--aircraft type
			inactive = false,
			country = "Iraq",								--unit country
			livery = "Iraqi",						--unit livery
			parking_id = {
				[""] = {49,60},
			},
			base = "Dubai Intl",						--unit base
			skill = "Random",
			tasks = {
				["Strike"] = true,
				["SEAD"] = false,
				["Intercept"] = false,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Runway Attack"] = true,
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "6th Squadron",								--unit name
			player = false,									--player unit
			inactive = false,
			type = "MiG-23MLD",								--aircraft type
			country = "Iraq",						--unit country
			livery = "af standard-2",			--unit livery
			parking_id = {
				[""] = {37,44},
			},
			base = "Sharjah Intl",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1,
				["Escort"] = 2,
				["Fighter Sweep"] = 1,	
			},
			number = 8,
			reserve = 24,
		},
		{
			name = "72nd Squadron",								--unit name
			type = "Su-17M4",								--aircraft type
			inactive = false,
			country = "Iraq",								--unit country
			livery = "Iraqi",									--unit livery
			parking_id = {
				[""] = {35,40},
			},
			base = "Dubai Intl",						--unit base
			skill = "high",									--unit skill
			tasks = {
				["Strike"] = true,
				["Anti-ship Strike"] = true,				
				["SEAD"] = false,
				["Laser Illumination"] = false,
				["Runway Attack"] = true,
			},
			number = 6,
			reserve = 18,
		},
		{
			name = "83 Squadron",							--unit name
			inactive = true,
			type = "MiG-25RBT",								--aircraft type
			country = "Iraq",								--unit country
			livery = {"Iraqi"},				--unit livery
			parking_id = {
				[""] = {125,132},
			},
			base = "Al Dhafra AFB",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = false,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Reconnaissance"] = true,				
			},
			number = 8,
			reserve = 18,
		},
		{
			name = "300 IAP",							--unit name
			inactive = true,
			type = "MiG-27K",							--aircraft type
			country = "Russia",							--unit country
			livery = "Iraqi",					--unit livery
			parking_id = {
				[""] = {85,96},
			},
			base = "Dubai Intl",						--unit base
			skill = "high",								--unit skill
			tasks = {
				["Strike"] = true,
				["SEAD"] = true,				
			},
			number = 12,
		},
		{
			name = "23 Squadron",							--unit name
			inactive = true,
			type = "MiG-25PD",							--aircraft type
			country = "Iraq",							--unit country
			livery = "",					--unit livery
			parking_id = {
				[""] = {91,98},
			},
			base = "Al Dhafra AFB",						--unit base
			skill = "high",								--unit skill
			tasks = {
				["Intercept"] = true,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = true,
			},
			number = 8,
		},
		{
			name = "14th Squadron",							--unit name
			player = false,									--player unit
			inactive = false,
			type = "MiG-21Bis",								--aircraft type
			country = "Iraq",								--unit country
			livery = {"Iraq - 17th Sqn (1)","Iraq - 17th Sqn (2)"},				--unit livery
			parking_id = {
				[""] = {1,12},
			},
			base = "Dubai Intl",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "51 Squadron",								--unit name
			type = "MiG-21Bis",								--aircraft type
			player = false,									--player unit
			inactive = false,
			country = "Iraq",								--unit country
			livery = {"Iraq - 17th Sqn (1)","Iraq - 17th Sqn (2)"},				--unit livery
			parking_id = {
				[""] = {1,12},
			},
			base = "Sharjah Intl",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = false,				
			},
			number = 12,
			reserve = 18,
		},
		{
			name = "81 Squadron",								--unit name
			inactive = true,
			player = false,									--player unit
			type = "Mirage-F1EE",								--aircraft type
			country = "Iraq",								--unit country
			livery = {"Iraq Air Force (FICTIONAL EQ VERSION)"},						--unit livery
			parking_id = {
				[""] = {61,72},
			},
			base = "Dubai Intl",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = false,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = true,
				["Runway Attack"] = true,
			},
			number = 12,
			reserve = 18,
		},
		{
			name = "79 Squadron",								--unit name
			inactive = true,
			player = false,									--player unit
			type = "Mirage-F1EE",								--aircraft type
			country = "Iraq",								--unit country
			livery = {"Iraq Air Force (FICTIONAL EQ VERSION)"},									--unit livery
			parking_id = {
				[""] = {13,24},
			},
			base = "Dubai Intl",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
				["Anti-ship Strike"] = true,
				["Runway Attack"] = true,
			},
			number = 12,
			reserve = 18,
		},
		{
			name = "60 Squadron",								--unit name
			player = false,									--player unit
			inactive = false,
			type = "SA342M",								--aircraft type
			helicopter = true,
			country = "Iraq",								--unit country
			livery = {"Iraq  Fictional"},									--unit livery
			base = "FARP Moscow",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,				
			},
			number = 8,
			reserve = 32,
		},
		{
			name = "70 Squadron",								--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-24P",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "Iraq",								--unit country
			livery = {"IQAF"},									--unit livery
			base = "FARP Warsaw",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Escort"] = true,
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["Escort"] = 1,
			},
			number = 8,
			reserve = 32,
		},		
	},
}

--List of aliases to replace type names in briefing/debriefing
TypeAlias = {
	["F-14B"] = "F-14A",
	["MirageF1CT"] = "Mirage F1 EQ5",
	["MirageF1"] = "Mirage F1 EQ",
	["Mirage-F1EE"] = "Mirage F1 EQ",
	["Mi-8MT"] = "Mi-17",
}


